<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card card-signin my-5 p-3">
                <div class="card-body">

                    <h5 class="text-center py-4"><?php echo e(__('Enter Your NIN and Answer the Question')); ?></h5>

                    <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger">
                            <span><?php echo e(session('error')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if(Session::has('success')): ?>
                        <div class="alert alert-success mb-4">
                            <span><?php echo e(session('success')); ?></span>
                        </div>
                    <?php endif; ?>

                    <!-- Form -->
                    <form method="POST" id="ninForm">
                        <?php echo csrf_field(); ?>

                        <!-- NIN Input -->
                        <div class="form-group">
                            <label for="nin">NIDA</label>
                            <input id="nin" type="text" placeholder="XXXXXXX-XXXX-XXXX-XXXXX"
                                class="form-control<?php echo e($errors->has('nin') ? ' is-invalid' : ''); ?>"
                                name="nin" value="<?php echo e(old('nin')); ?>">
                            <?php if($errors->has('nin')): ?>
                                <span class="invalid-feedback">
                                    <strong><?php echo e($errors->first('nin')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>

                        <!-- Question & Answer section hidden initially -->
                        <div id="questionAnswerSection" style="display:none;">
                            <div class="form-group">
                                <label>QUESTION:</label>
                                <label id="questionEN" class="form-control-plaintext font-weight-bold"></label>
                            </div>
                            <div class="form-group">
                                <label id="previousAnsw" class="form-control-plaintext font-weight-bold"></label>
                            </div>
                            <div class="form-group">
                                <label>SWALI:</label>
                                <label id="questionSW" class="form-control-plaintext font-weight-bold"></label>
                            </div>
                            <input type="hidden" name="RQCode" id="RQCode" value="<?php echo e(old('RQCode')); ?>">

                            <div class="form-group">
                                <label for="answer">ANSWER</label>
                                <input id="answer" type="text" class="form-control<?php echo e($errors->has('answer') ? ' is-invalid' : ''); ?>"
                                    name="answer" value="<?php echo e(old('answer')); ?>" style="text-transform: uppercase;" oninput="this.value = this.value.toUpperCase();">
                                <?php if($errors->has('answer')): ?>
                                    <span class="invalid-feedback">
                                        <strong><?php echo e($errors->first('answer')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Personal Info (populated if CODE == "00") -->
                        <div id="personalInfoSection" style="display:none;">
                            <div class="form-group">
                                <label>First Name</label>
                                <input type="text" id="firstname" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Middle Name</label>
                                <input type="text" id="middlename" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Surname</label>
                                <input type="text" id="surname" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Sex</label>
                                <input type="text" id="sex" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Date of Birth</label>
                                <input type="text" id="dob" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Nationality</label>
                                <input type="text" id="nationality" class="form-control" disabled>
                            </div>
                            <div class="form-group">
                                <label>Photo</label><br>
                                <img id="photoPreview" src="" alt="User Photo" style="max-width: 150px; border: 1px solid #ccc; padding: 4px;" />
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="form-group text-center mt-4">
                            <button type="button" class="btn btn-primary" id="submitBtn">
                                <?php echo e(__('Submit')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Script -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const submitBtn = document.getElementById('submitBtn');
    const ninInput = document.getElementById('nin');
    const questionAnswerSection = document.getElementById('questionAnswerSection');
    const questionEN = document.getElementById('questionEN');
    const questionSW = document.getElementById('questionSW');
    const previousAnsw = document.getElementById('previousAnsw');
    const RQCode = document.getElementById('RQCode');
    const form = document.getElementById('ninForm');
    const answer = document.getElementById('answer');
    const personalInfoSection = document.getElementById('personalInfoSection');

    // Personal Info Fields
    const firstname = document.getElementById('firstname');
    const middlename = document.getElementById('middlename');
    const surname = document.getElementById('surname');
    const sex = document.getElementById('sex');
    const dob = document.getElementById('dob');
    const nationality = document.getElementById('nationality');
    const photoPreview = document.getElementById('photoPreview');

    submitBtn.addEventListener('click', function() {
        const nin = ninInput.value.trim();
        const answ = answer.value.trim();
        const rqcode = RQCode.value.trim();

        if (!/^\d{20}$/.test(nin)) {
            alert("Please enter a valid 20-digit NIN.");
            return;
        }

        const APP_URL = "<?php echo e(url('/')); ?>";
        let apiUrl = "";

        if (answ && rqcode) {
            apiUrl = APP_URL + '/user/nida/answerQuestions/' + nin + '/' + rqcode + '/' + answ;
        } else {
            apiUrl = APP_URL + '/user/nida/information/' + nin;
        }

        fetch(apiUrl)
            .then(response => response.json())
            .then(data => {
                 alert(JSON.stringify(data.data, null, 2));
                if (data.data.CODE === "120") {
                    previousAnsw.textContent = "";
                    questionEN.textContent = data.data.EN;
                    questionSW.textContent = data.data.SW;
                    RQCode.value = data.data.RQCode;
                    if(data.data.PREV_ANSW_CODE === "124"){
                      previousAnsw.textContent = "Previous answer was incorrect";
                    }else if (data.data.PREV_ANSW_CODE === "124"){
                        previousAnsw.textContent = "Previous answer was correct";
                    }
                    
                    questionAnswerSection.style.display = 'block';
                    personalInfoSection.style.display = 'none';
                    answer.focus();
                } else if (data.data.CODE === "00") {
                    previousAnsw.textContent = "";
                    // Populate personal info
                    firstname.value = data.data.FIRSTNAME || "";
                    middlename.value = data.data.MIDDLENAME || "";
                    surname.value = data.data.SURNAME || "";
                    sex.value = data.data.SEX || "";
                    dob.value = data.data.DATEOFBIRTH || "";
                    nationality.value = data.data.NATIONALITY || "";

                    if (data.data.PHOTO) {
                        photoPreview.src = `data:image/jpeg;base64,${data.data.PHOTO}`;
                    } else {
                        photoPreview.src = "";
                    }

                    personalInfoSection.style.display = 'block';
                    questionAnswerSection.style.display = 'none';

                } else {
                    alert(JSON.stringify(data.error, null, 2));
                    previousAnsw.textContent = data.error;
                    questionEN.textContent = "";
                    questionSW.textContent = "";
                    RQCode.value = "";
                    answer.value = "";
                }
            })
            .catch(error => {
                console.error("Error fetching data:", error);
                alert("Failed to process. Please try again.");
            });
    });
});
</script>
<?php /**PATH C:\Users\nsaji\Downloads\kopa-main-nida-part\my-app\resources\views/welcome.blade.php ENDPATH**/ ?>